import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class Html {

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);
        String str = in.nextLine();

        boolean valid = validateHtml(str);
        String res = valid ? "Yes" : "No";

        System.out.println(res);
    }

    public static boolean validateHtml(String str) {
        if (str.isEmpty()) {
            return false;
        }

        if (str.charAt(0) != '<' || str.charAt(str.length() - 1) != '>') {
            return false;
        }

        Set<String> opened = new HashSet<>();
        Set<String> closed = new HashSet<>();
        boolean openBracket = false;
        boolean closeBracket = true; // initial 'true' undermines that it's start of the string and next valid char is '<'
        boolean closeSlash = false;
        boolean tagName = false;
        boolean startTag = false;
        boolean endTag = false;
        StringBuilder name = new StringBuilder();
        for (char ch : str.toCharArray()) {
            switch (ch) {
                case '<':
                    if (!closeBracket) {
                        return false;
                    }
                    openBracket = true;
                    closeBracket = false;
                    break;
                case '>':
                    if (!tagName) {
                        return false;
                    }
                    closeBracket = true;
                    tagName = false;
                    if (name.length() < 1) {
                        return false;
                    }
                    if (startTag) {
                        opened.add(name.toString());
                        startTag = false;
                    } else if (endTag) {
                        closed.add(name.toString());
                        endTag = false;
                        if (!opened.contains(name.toString())) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    break;
                case '/':
                    if (openBracket) {
                        closeSlash = true;
                        break;
                    } else {
                        return false;
                    }
                default:
                    if (tagName) {
                        name.append(ch);
                    } else if (closeSlash) {
                        tagName = true;
                        endTag = true;
                        name.setLength(0);
                        name.append(ch);
                    } else if (openBracket) {
                        tagName = true;
                        startTag = true;
                        name.setLength(0);
                        name.append(ch);
                    }
                    openBracket = false;
                    closeBracket = false;
                    closeSlash = false;
            }
        }

        return opened.equals(closed);
    }
}
